/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumatic_armor;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import me.desht.pneumaticcraft.api.PneumaticRegistry;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IArmorUpgradeClientHandler;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.ICheckboxWidget;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumatic_helmet.IOptionPage;
import me.desht.pneumaticcraft.api.item.PNCUpgrade;
import me.desht.pneumaticcraft.api.pneumatic_armor.IArmorUpgradeHandler;
import me.desht.pneumaticcraft.client.gui.AbstractPneumaticCraftScreen;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.options.NullOptions;
import me.desht.pneumaticcraft.client.gui.widget.WidgetButtonExtended;
import me.desht.pneumaticcraft.client.pneumatic_armor.ClientArmorRegistry;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.config.subconfig.ArmorFeatureStatus;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.item.PneumaticArmorItem;
import me.desht.pneumaticcraft.common.pneumatic_armor.ArmorUpgradeRegistry;
import me.desht.pneumaticcraft.common.pneumatic_armor.CommonArmorHandler;
import me.desht.pneumaticcraft.common.pneumatic_armor.handlers.CoreComponentsHandler;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class ArmorMainScreen
extends AbstractPneumaticCraftScreen
implements IGuiScreen {
    private static final ChatFormatting[] TITLE_PREFIX = new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.UNDERLINE};
    public static final ItemStack[] ARMOR_STACKS = new ItemStack[]{new ItemStack((ItemLike)ModItems.PNEUMATIC_BOOTS.get()), new ItemStack((ItemLike)ModItems.PNEUMATIC_LEGGINGS.get()), new ItemStack((ItemLike)ModItems.PNEUMATIC_CHESTPLATE.get()), new ItemStack((ItemLike)ModItems.PNEUMATIC_HELMET.get())};
    private static ArmorMainScreen instance;
    private static int pageNumber;
    private final List<UpgradeOption> upgradeOptions = new ArrayList<UpgradeOption>();
    private boolean inInitPhase = true;
    private final UpgradeOption nullOptionsPage = new UpgradeOption(new NullOptions(this), PneumaticRegistry.RL("null"), new ItemStack((ItemLike)Items.f_42127_));

    private ArmorMainScreen() {
        super((Component)Component.m_237113_((String)"Main Screen"));
    }

    public static ArmorMainScreen getInstance() {
        return instance;
    }

    public static void initHelmetCoreComponents() {
        if (instance == null) {
            instance = new ArmorMainScreen();
            Window mw = Minecraft.m_91087_().m_91268_();
            instance.m_6575_(Minecraft.m_91087_(), mw.m_85445_(), mw.m_85446_());
            int i = 1;
            while (i < ArmorMainScreen.instance.upgradeOptions.size()) {
                pageNumber = i++;
                instance.m_7856_();
            }
            pageNumber = 0;
            ArmorMainScreen.instance.inInitPhase = false;
            ArmorFeatureStatus.INSTANCE.saveIfChanged();
        }
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.xSize = this.f_96543_;
        this.ySize = this.f_96544_;
        this.m_169413_();
        this.upgradeOptions.clear();
        this.addPages();
        int xPos = 200;
        int yPos = 5;
        int buttonWidth = this.f_96547_.m_92852_((FormattedText)PneumaticCraftUtils.xlate("pneumaticcraft.armor.upgrade.core_components", new Object[0]));
        for (UpgradeOption opt : this.upgradeOptions) {
            buttonWidth = Math.max(buttonWidth, this.f_96547_.m_92852_((FormattedText)opt.page.getPageName()));
        }
        for (int i = 0; i < this.upgradeOptions.size(); ++i) {
            int idx = i;
            WidgetButtonExtended button = new WidgetButtonExtended(xPos, yPos, buttonWidth + 10, 20, (Component)this.upgradeOptions.get((int)i).page.getPageName(), b -> this.setPage(idx));
            button.setHighlightWhenInactive(true);
            button.setRenderStacks(this.upgradeOptions.get((int)i).icons).setIconPosition(WidgetButtonExtended.IconPosition.RIGHT).setIconSpacing(12);
            if (pageNumber == i) {
                button.f_93623_ = false;
            }
            this.m_142416_((GuiEventListener)button);
            if ((yPos += 22) <= this.ySize - 22) continue;
            yPos = 5;
            xPos += buttonWidth + 55;
        }
        if ((pageNumber = Math.min(pageNumber, this.upgradeOptions.size() - 1)) < 0 && !this.upgradeOptions.isEmpty()) {
            pageNumber = 0;
        }
        ICheckboxWidget checkBox = PneumaticRegistry.getInstance().getClientArmorRegistry().makeKeybindingCheckBox(this.getCurrentOptionsPage().upgradeID, 40, 25, -1, null);
        if (this.getCurrentOptionsPage().page.isToggleable()) {
            this.m_142416_((GuiEventListener)checkBox.asWidget());
        }
        this.getCurrentOptionsPage().page.populateGui(this);
    }

    private void setPage(int newPage) {
        pageNumber = newPage;
        this.m_7856_();
    }

    public UpgradeOption getCurrentOptionsPage() {
        if (pageNumber >= 0 && pageNumber < this.upgradeOptions.size()) {
            return this.upgradeOptions.get(pageNumber);
        }
        return this.nullOptionsPage;
    }

    @Override
    protected ResourceLocation getTexture() {
        return null;
    }

    private void addPages() {
        for (EquipmentSlot slot : ArmorUpgradeRegistry.ARMOR_SLOTS) {
            List<IArmorUpgradeHandler<?>> upgradeHandlers = ArmorUpgradeRegistry.getInstance().getHandlersForSlot(slot);
            for (int i = 0; i < upgradeHandlers.size(); ++i) {
                IArmorUpgradeClientHandler<?> clientHandler;
                IOptionPage optionPage;
                if (!this.inInitPhase && !CommonArmorHandler.getHandlerForPlayer().isUpgradeInserted(slot, i) && (slot != EquipmentSlot.HEAD || i != 0)) continue;
                IArmorUpgradeHandler<?> handler = upgradeHandlers.get(i);
                if (!this.inInitPhase && !PneumaticArmorItem.isPneumaticArmorPiece(ClientUtils.getClientPlayer(), slot) && !(handler instanceof CoreComponentsHandler) || (optionPage = (clientHandler = ClientArmorRegistry.getInstance().getClientHandler(handler.getID())).getGuiOptionsPage(this)) == null) continue;
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                stacks.add(ARMOR_STACKS[handler.getEquipmentSlot().m_20749_()]);
                Arrays.stream(handler.getRequiredUpgrades()).map(PNCUpgrade::getItemStack).forEach(stacks::add);
                this.upgradeOptions.add(new UpgradeOption(optionPage, handler.getID(), stacks.toArray(new ItemStack[0])));
            }
        }
    }

    @Override
    public void m_6305_(PoseStack matrixStack, int x, int y, float partialTicks) {
        this.m_7333_(matrixStack);
        IOptionPage optionPage = this.getCurrentOptionsPage().page;
        optionPage.renderPre(matrixStack, x, y, partialTicks);
        ArmorMainScreen.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)this.getCurrentOptionsPage().page.getPageName().m_6881_().m_130944_(TITLE_PREFIX), (int)100, (int)12, (int)-1);
        if (optionPage.displaySettingsHeader()) {
            ArmorMainScreen.m_93215_((PoseStack)matrixStack, (Font)this.f_96547_, (Component)PneumaticCraftUtils.xlate("pneumaticcraft.armor.gui.misc.settings", new Object[0]).m_130940_(ChatFormatting.DARK_AQUA), (int)100, (int)optionPage.settingsYposition(), (int)-1);
        }
        super.m_6305_(matrixStack, x, y, partialTicks);
        optionPage.renderPost(matrixStack, x, y, partialTicks);
    }

    @Override
    public void m_86600_() {
        super.m_86600_();
        IOptionPage optionPage = this.getCurrentOptionsPage().page;
        optionPage.tick();
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return this.getCurrentOptionsPage().page.keyPressed(keyCode, scanCode, modifiers) || super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        return this.getCurrentOptionsPage().page.keyReleased(keyCode, scanCode, modifiers) || super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        return this.getCurrentOptionsPage().page.mouseClicked(mouseX, mouseY, mouseButton) || super.m_6375_(mouseX, mouseY, mouseButton);
    }

    public boolean m_6050_(double mouseX, double mouseY, double dir) {
        return this.getCurrentOptionsPage().page.mouseScrolled(mouseX, mouseY, dir) || super.m_6050_(mouseX, mouseY, dir);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.getCurrentOptionsPage().page.mouseDragged(mouseX, mouseY, button, dragX, dragY) || super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public <T extends AbstractWidget> T addWidget(T w) {
        return (T)((AbstractWidget)this.m_142416_((GuiEventListener)w));
    }

    @Override
    public List<Widget> getWidgetList() {
        return ImmutableList.copyOf((Collection)this.f_169369_);
    }

    @Override
    public Font getFontRenderer() {
        return this.f_96547_;
    }

    @Override
    public void setFocusedWidget(AbstractWidget w) {
        this.m_7522_((GuiEventListener)w);
    }

    public boolean m_7043_() {
        return false;
    }

    public record UpgradeOption(IOptionPage page, ResourceLocation upgradeID, ItemStack[] icons) {
    }
}

